
<!-- header.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Shop Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            max-width: 500px;
            margin-top: 50px;
        }
    </style>
</head>
<body>

<?php
session_start();
include 'php/db_connection.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['id'])) {
    header("Location: manage_users.php");
    exit();
}

$id = $_GET['id'];
$result = $con->prepare("SELECT * FROM users_shop WHERE id = ?");
$result->bind_param("i", $id);
$result->execute();
$user = $result->get_result()->fetch_assoc();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $role = $_POST['role'];

    $stmt = $con->prepare("UPDATE users_shop SET name = ?, email = ?, role = ? WHERE id = ?");
    $stmt->bind_param("sssi", $name, $email, $role, $id);
    if ($stmt->execute()) {
        echo "<script>alert('তথ্য আপডেট হয়েছে!'); window.location='manage_users.php';</script>";
    }
}

/*----------------------------------------inclode------------------------*/

?>
<?php include 'sidebar.php'; ?>

<div class="container mt-4">
    <h2 class="text-center">ইউজার এডিট করুন</h2>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">নাম</label>
            <input type="text" name="name" class="form-control" value="<?= $user['name'] ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ইমেইল</label>
            <input type="email" name="email" class="form-control" value="<?= $user['email'] ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ভূমিকা</label>
            <select name="role" class="form-select">
                <option value="user" <?= $user['role'] == 'user' ? 'selected' : '' ?>>User</option>
                <option value="admin" <?= $user['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">সংরক্ষণ করুন</button>
        <a href="manage_users.php" class="btn btn-secondary">ফিরে যান</a>
    </form>
</div>
</body>
</html>
