fetch(`check_stock.php?product_id=${productId}`)
    .then(response => response.text())   // প্রথমে raw text দেখুন
    .then(text => {
        console.log("Server Response:", text);
        let data = JSON.parse(text);
        
        if (data.error) {
            alert(data.error);
            return;
        }

        if (parseInt(data.available_quantity) > 0) {
            addProductToList({
                id: data.Product_id,
                description: data.description,
                price: parseFloat(data.price),
                purchase_price: parseFloat(data.purchase_price),
            });
        } else {
            alert(`Product ID ${data.Product_id} is out of stock.`);
        }

        document.getElementById("scanInput").value = '';
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while scanning the product.');
    });
