<!-- header.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Shop Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            max-width: 500px;
            margin-top: 50px;
        }
    </style>
</head>
<body>


<?php
session_start();
include 'php/db_connection.php'; // ডাটাবেজ কানেকশন ফাইল

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $con->prepare("SELECT * FROM users_shop WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['user_name'] = $row['name'];
            $_SESSION['role'] = $row['role'];

            if ($row['role'] == 'admin') {
                header("Location: index.php");
            } else {
                header("Location: index.php");
            }
        } else {
            echo "ভুল পাসওয়ার্ড!";
        }
    } else {
        echo "ইমেইল পাওয়া যায়নি!";
    }
}
?>
<div class="container">
    <div class="card p-4 shadow-sm">
        <h2 class="text-center">লগইন করুন</h2>
        <form method="post">
            <div class="mb-3">
                <label class="form-label">ইমেইল</label>
                <input type="email" name="email" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">পাসওয়ার্ড</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">লগইন</button>
        </form>
        <p class="text-center mt-3"><a href="register.php">নতুন অ্যাকাউন্ট খুলুন</a></p>
    </div>
</div>
</body>
</html>