<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php

// Fetch Customer and Sales Data by ID
if (isset($_GET['id'])) {
    $customer_id = $conn->real_escape_string($_GET['id']);
    $sql = "SELECT * FROM sales WHERE id = $customer_id";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        // Fetch Sales Items for the specific sale
        $items_sql = "SELECT product_id, product_description, quantity, price, total FROM sales_items WHERE sales_id = $customer_id";
        $items_result = $conn->query($items_sql);
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Customer Sales Report</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    margin: 0;
                    padding: 20px;
                    background-color: #f4f4f4;
                    color: #333;
                }
                .container {
                    width: 25%;
                    margin: 0 auto;
                    background-color: #fff;
                    padding: 20px;
                    border-radius: 8px;
                    box-shadow: 0px 0px 10px rgba(0,0,0,0.1);
                }
                h2 {
                    text-align: center;
                    color: #3498db;
                }
                .details {
                    display: flex;
                    justify-content: space-between;
                    padding: 10px 0;
                    border-bottom: 1px solid #ccc;
                }
                .details p {
                    margin: 5px 0;
                }
                .details-label {
                    font-weight: bold;
                }
                table {
                    width: 10%;
                    border-collapse: collapse;
                    margin-top: 20px;
                }
                th, td {
                    padding: 8px;
                    text-align: left;
                    border: 1px solid #ccc;
                }
                th {
                    background-color: #3498db;
                    color: white;
                }
                .total-section {
                    text-align: right;
                    padding: 15px 0;
                    margin-top: 15px;
                    border-top: 1px solid #ccc;
                }
                .total-section span {
                    font-size: 18px;
                    font-weight: bold;
                }
                .action-buttons {
                    display: flex;
                    justify-content: center;
                    gap: 10px;
                    margin-top: 20px;
                }
                .action-button {
                    padding: 10px 15px;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                    text-align: center;
                    text-decoration: none;
                    display: inline-block;
                }
                .print-button {
                    background-color: #e74c3c;
                    color: white;
                }
                .print-button:hover {
                    background-color: #c0392b;
                }
                .delete-button {
                    background-color: #e74c3c;
                    color: white;
                }
                .delete-button:hover {
                    background-color: #c0392b;
                }
                @media print {
                    .action-buttons {
                        display: none;
                    }
                }
            </style>
            <script>
                function printReport() {
                    window.print();
                }
                function deleteSale(id) {
                    if (confirm("Are you sure you want to delete this sale?")) {
                        window.location.href = "delete_sale.php?id=" + id;
                    }
                }
            </script>
        </head>
        <body>
            <div class="container">
                <h1>BBE.COM</h1>
                <h3>Mulagul Bagar Kanaighat Sylhet </h3>
                <P></P>
                <P>Phone: 01738554382</P>
                <div class="details">
                    <p class="details-label">Date:</p>
                    <p><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></p>
                </div>
                <h2>Customer Sales Report</h2>
                <div class="details">
                    <p class="details-label">ID:</p>
                    <p><?php echo $row['id']; ?></p>
                </div>
                <div class="details">
                    <p class="details-label">Customer Name:</p>
                    <p><?php echo htmlspecialchars($row['customer_name']); ?></p>
                </div>
                <div class="details">
                    <p class="details-label">Customer Address:</p>
                    <p><?php echo htmlspecialchars($row['customer_address']); ?></p>
                </div>
                
                <div class="details">
                    <p class="details-label">Customer Phone:</p>
                    <p><?php echo htmlspecialchars($row['customer_phone']); ?></p>
                </div>
                
                <!-- Sales Items Table -->
                <table>
                    <tr>
                        <th>ID</th>
                        <th>Product</th>
                        <th>Quantity</th>
                        <th>Unit Price</th>
                        <th>Total Price</th>
                    </tr>
                    <?php if ($items_result->num_rows > 0): ?>
                        <?php while ($item = $items_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($item['product_id']); ?></td>
                                <td><?php echo htmlspecialchars($item['product_description']); ?></td>
                                <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                                <td><?php echo number_format($item['price'], 2); ?></td>
                                <td><?php echo number_format($item['total'], 2); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5">No items found for this sale</td>
                        </tr>
                    <?php endif; ?>
                </table>
    
                <div class="total-section">
                    <span>Total: <?php echo number_format($row['grand_total'], 2); ?></span>
                </div>
                <div class="total-section">
                    <span>Collected: <?php echo number_format($row['collected'], 2); ?></span>
                </div>
                <div class="total-section">
                    <span>Final_amount: <?php echo number_format($row['final_amount'], 2); ?></span>
                </div>
                <div class="total-section">
                    <span>Change: <?php echo number_format($row['change'], 2); ?></span>
                </div>
                <div class="details">
                    <p class="details-label">Discount:</p>
                    <p><?php echo number_format($row['discount'], 2); ?></p>
                </div>
                <!-------------------------Total-Discount------------->
                <?php
            $x =  number_format($row['discount'], 2); 
            $y =  number_format($row['grand_total'], 2);
              ?> 
                <div class="details">
                    <p class="details-label">Final Total:</p>
                    <p><?php echo $y - $x; ?></p>
                </div>
                
                <div class="action-buttons">
                    <a href="#" class="action-button print-button" onclick="printReport(); return false;">Print</a>
                    <a href="#" class="action-button delete-button" onclick="deleteSale(<?php echo $row['id']; ?>); return false;">Delete</a>
                    <a href="#" class="action-button edit-button" onclick="editSale(<?php echo $row['id']; ?>); return false;">Edit</a>
                </div>
            </div>
        </body>
        </html>
        <?php
    } else {
        echo "No data found for this customer.";
    }
} else {
    echo "No customer ID provided.";
}

$conn->close();
?>
