
<!----------------------------------Login------------------------------------>
<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে


$isAdmin = ($_SESSION['role'] == 'admin');

?>


<?php
// Database Connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "shop";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Pagination Variables
$limit = 10; // প্রতিটি পৃষ্ঠায় ১০টি রেকর্ড প্রদর্শন
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Handle Delete Action
if (isset($_GET['delete_id'])) {
    $delete_id = $_GET['delete_id'];
    $sql = "DELETE FROM suppliers WHERE id = $delete_id";
    if ($conn->query($sql) === TRUE) {
        header("Location: " . $_SERVER['PHP_SELF'] . "?page=$page");
        exit();
    } else {
        echo "<div class='alert alert-danger'>ডিলিট করতে ব্যর্থ: " . $conn->error . "</div>";
    }
}

// Handle Form Submission (for Add or Edit)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $mobile = $_POST['mobile'];
    $email = $_POST['email'];
    $address = $_POST['address'];

    if (!empty($_POST['id'])) {
        $id = $_POST['id'];
        $sql = "UPDATE suppliers SET name='$name', mobile='$mobile', email='$email', address='$address' WHERE id=$id";
    } else {
        $sql = "INSERT INTO suppliers (name, mobile, email, address) VALUES ('$name', '$mobile', '$email', '$address')";
    }

    if ($conn->query($sql) === TRUE) {
        header("Location: " . $_SERVER['PHP_SELF'] . "?page=$page");
        exit();
    } else {
        echo "<div class='alert alert-danger'>ত্রুটি: " . $conn->error . "</div>";
    }
}

// Fetch Data with Search
$search = isset($_GET['search']) ? $_GET['search'] : '';

$sql = "SELECT * FROM suppliers 
        WHERE name LIKE '%$search%' 
           OR mobile LIKE '%$search%' 
           OR email LIKE '%$search%'
        ORDER BY id DESC LIMIT $limit OFFSET $offset";
$result = $conn->query($sql);

// Fetch Total Suppliers for Pagination
$total_sql = "SELECT COUNT(*) as total FROM suppliers 
              WHERE name LIKE '%$search%' 
                 OR mobile LIKE '%$search%' 
                 OR email LIKE '%$search%'";
$total_result = $conn->query($total_sql);
$total_row = $total_result->fetch_assoc();
$total_suppliers = $total_row['total'];
$total_pages = ceil($total_suppliers / $limit);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>সাপ্লাইয়ার ম্যানেজমেন্ট</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        #form-section {
            display: none;
        }
        

/*-------------পেইজ নেভসহ টেবিল কোড--------------------------------*/
/* Pagination Styling */
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .pagination a {
            margin: 0 5px;
            padding: 8px 16px;
            text-decoration: none;
            color: #007bff;
            border: 1px solid #007bff;
            border-radius: 5px;
            font-size: 16px;
        }
        .pagination a:hover {
            background-color: #007bff;
            color: white;
        }
        .pagination .active {
                background-color: #007bff;
                color: white;
                padding: 10px;
            }
.table-white {
  background-color: #f8f9fa; /* হালকা সাদা */
  color: #333; /* টেক্সট কালার যাতে ভালোভাবে দেখা যায় */
}
    </style>
</head>
<body>
<?php include 'sidebar.php'; ?>
<div class="container my-4">
    
    <!-- Search Form 
    <div class="row mb-3">
        <div class="col-md-6">
            <form method="GET" action="">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Search by Name, Phone, or Email" value="<?php echo htmlspecialchars($search); ?>">
                    <button type="submit" class="btn btn-primary">Search</button>
                </div>
            </form>
        </div>
    </div>--------------পুরাতন বন্ধ করা হলো---------->

    <!-- Add Button -->
    <div class="text-end mb-3">
    <!-----লগইন এডমিন এবং ইউজার------->
    <?php if ($isAdmin): ?>
        <button class="btn btn-primary" onclick="showForm()">Add New Supplier</button>
        <?php else: ?>
    <span class="text-muted"><!-----কিছু দেখাতে চাইলে পারবেন-------></span>
        <?php endif; ?>
    </div>

    <!-- Add/Edit Form -->
    <div id="form-section" class="card mb-4">
        <div class="card-header bg-primary text-white d-flex justify-content-between">
            <h3><?php echo isset($_GET['edit_id']) ? 'Edit Supplier' : 'Add New Supplier'; ?></h3>
            <button class="btn-close" onclick="closeForm()"></button>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input  type="hidden" name="id"  value="<?php echo isset($_GET['edit_id']) ? $_GET['edit_id'] : ''; ?>">
                <div class="mb-3">
                    <label for="name" class="form-label">Name:</label>
                    <input type="text" id="name" name="name" class="form-control" required value="<?php echo isset($_GET['edit_name']) ? $_GET['edit_name'] : ''; ?>">
                </div>
                <div class="mb-3">
                    <label for="mobile" class="form-label">Phone:</label>
                    <input type="text" id="mobile" name="mobile" class="form-control" required value="<?php echo isset($_GET['edit_mobile']) ? $_GET['edit_mobile'] : ''; ?>">
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">Email:</label>
                    <input type="email" id="email" name="email" class="form-control" required value="<?php echo isset($_GET['edit_email']) ? $_GET['edit_email'] : ''; ?>">
                </div>
                <div class="mb-3">
                    <label for="address" class="form-label">Address:</label>
                    <textarea id="address" name="address" class="form-control" required><?php echo isset($_GET['edit_address']) ? $_GET['edit_address'] : ''; ?></textarea>
                </div>
                <button type="submit" class="btn btn-success"><?php echo isset($_GET['edit_id']) ? 'Update' : 'Submit'; ?></button>
            </form>
        </div>
    </div>

    <!-- Supplier List -->
    <div class="card">
        <div style="padding: 10px;">
            <!----------------<h3>List of Suppliers</h3>--------------------->
            <form method="GET" action="">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Search by Name, Phone, or Email" value="<?php echo htmlspecialchars($search); ?>">
                    <button type="submit" class="btn btn-primary">Search</button>
                </div>
            </form>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="table-white">
                <tr>
                    <th>Serial</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Address</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php 
                    $serial = $offset + 1;
                    while($row = $result->fetch_assoc()): 
                    ?>
                        <tr>
                            <td><?php echo $serial++; ?></td>
                            <td><?php echo $row['name']; ?></td>
                            <td><?php echo $row['mobile']; ?></td>
                            <td><?php echo $row['email']; ?></td>
                            <td><?php echo $row['address']; ?></td>
                            <td><?php echo $row['created_at']; ?></td>
                            <td>
                                <!-----লগইন এডমিন এবং ইউজার------->
                                <?php if ($isAdmin): ?>
                                <a href="?edit_id=<?php echo $row['id']; ?>&edit_name=<?php echo $row['name']; ?>&edit_mobile=<?php echo $row['mobile']; ?>&edit_email=<?php echo $row['email']; ?>&edit_address=<?php echo $row['address']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('আপনি কি সত্যিই মুছতে চান?');">Delete</a>
                                <?php else: ?>
                                <span class="text-muted">No Permission</span>
                                 <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">No suppliers found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

            <!-- Pagination 
            <nav>
                <ul class="pagination justify-content-center">
                    <?php /*--------------------------------------------------পুরাতন পেইজ নেভ বন্ধ------- 
                    for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                            <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; 
                    ---------------------------------------------------------------------------*/
                    ?>
                
                </ul>

            </nav>
             <!-- Pagination Links -->
        <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?page=<?php echo $page - 1; ?>">Prev</a>
        <?php endif; ?>

        <!-- Display Current Page Range (ex: 1-5, 6-10, etc.) -->
        <span class="active">Page <?php echo $page; ?> of <?php echo $total_pages; ?></span>

        <?php if ($page < $total_pages): ?>
            <a href="?page=<?php echo $page + 1; ?>">Next</a>
        <?php endif; ?>
    </div>
        </div>
    </div>
</div>


  

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function showForm() {
        document.getElementById('form-section').style.display = 'block';
    }
    function closeForm() {
        document.getElementById('form-section').style.display = 'none';
    }
</script>
</body>
</html>
