<!----------------------------------Login------------------------------------>
<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$isAdmin = ($_SESSION['role'] == 'admin');

?>

<?php
// Include database connection
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "shop";

$con = new mysqli($servername, $username, $password, $dbname);
if ($con->connect_error) {
    die("Connection failed: " . $con->connect_error);
}

$successMessage = '';

// Handle product addition
if (isset($_POST['action']) && $_POST['action'] == 'addProduct') {
    $productName = $_POST['productName'];
    $productId = $_POST['productId'];
    $price = $_POST['price'];
    $purchasePrice = $_POST['purchasePrice'];  // Add purchase price

    // Insert the new product into the database
    $insert = "INSERT INTO product_cat (Product_name, Product_id, price, purchase_price) 
               VALUES ('$productName', '$productId', '$price', '$purchasePrice')";
    $query = mysqli_query($con, $insert);

    if ($query) {
        echo json_encode(['status' => 'success', 'message' => 'Product added successfully!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to add product.']);
    }
    exit;  // Prevent further execution
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Product</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; }
        .add-product-container { margin-top: 50px; text-align: center; }
        .submit-button, .close-button, .add-product-button { background-color: #3498db; color: white; padding: 8px 16px; border: none; cursor: pointer; margin: 5px; }
        .close-button { background-color: #e74c3c; }
        .add-product-button { background-color: #2ecc71; }
        .form-container { display: none; margin-top: 20px; }
        input { margin: 5px; padding: 10px; width: 200px; }
        .success-message { background-color: #2ecc71; color: white; padding: 10px; margin-top: 20px; text-align: center; display: none; }
    </style>
    <script>
        function showForm() {
            document.getElementById('productFormContainer').style.display = 'block';
            document.getElementById('successMessage').style.display = 'none'; // Hide success message
        }

        function hideForm() {
            document.getElementById('productFormContainer').style.display = 'none';
        }

        function addProduct(event) {
            event.preventDefault();  // Prevent form from submitting the traditional way
            const productName = document.getElementById('addProductName').value;
            const productId = document.getElementById('addProductId').value;
            const price = document.getElementById('addPrice').value;
            const purchasePrice = document.getElementById('addPurchasePrice').value;  // Get purchase price

            if (productName && productId && price && purchasePrice) {
                var xhr = new XMLHttpRequest();
                xhr.open("POST", "", true);
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                xhr.onreadystatechange = function () {
                    if (xhr.readyState == 4 && xhr.status == 200) {
                        var response = JSON.parse(xhr.responseText);
                        if (response.status === 'success') {
                            // Show success message and hide form
                            document.getElementById('successMessage').innerHTML = response.message;
                            document.getElementById('successMessage').style.display = 'block';
                            document.getElementById('productFormContainer').style.display = 'none';
                        } else {
                            alert(response.message);
                        }
                    }
                };
                xhr.send(`action=addProduct&productName=${encodeURIComponent(productName)}&productId=${encodeURIComponent(productId)}&price=${encodeURIComponent(price)}&purchasePrice=${encodeURIComponent(purchasePrice)}`);
            } else {
                alert("Please fill in all fields.");
            }
        }
    </script>
</head>
<body>
    <div class="add-product-container">
        <!-- Success Message -->
        <div id="successMessage" class="success-message"></div>

        <!-- Add Product Button -->
        <button class="add-product-button" onclick="showForm()">Add Product</button>
        
        <!-- Product Form -->
        <div id="productFormContainer" class="form-container">
            <h2>Add Product</h2>
            <input type="text" id="addProductName" placeholder="Product Name">
            <input type="text" id="addProductId" placeholder="Product ID">
            <input type="text" id="addPrice" placeholder="Selling Price">
            <input type="text" id="addPurchasePrice" placeholder="Purchase Price">  <!-- Add purchase price field -->
            <div>
                <button type="button" class="submit-button" onclick="addProduct(event)">Submit</button>
                <button type="button" class="close-button" onclick="hideForm()">Close</button> <!-- Close button -->
            </div>
        </div>
    </div>
</body>
</html>
